<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Admin/Option.php';
require_once MAX_PATH . '/lib/OA/Admin/Settings.php';

require_once MAX_PATH . '/lib/max/Plugin/Translation.php';
require_once MAX_PATH . '/www/admin/config.php';
if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}
$table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];

// Security check
OA_Permission::enforceAccount(OA_ACCOUNT_ADMIN);

// Create a new option object for displaying the setting's page's HTML form
$oOptions = new OA_Admin_Option('settings');
$prefSection = "emailzone-destination";
// Prepare an array for storing error messages
$aErrormessage = array();
// If the settings page is a submission, deal with the form data
if (isset($_POST['submitok']) && $_POST['submitok'] == 'true') {
	$dest = OA_Dal_Delivery_query("SELECT * FROM ".$table_prefix."dj_emailzone_settings");
	$dest_url = $_POST['destination_url'];
	
	if(OA_Dal_Delivery_numRows($dest)==0){
		if(!empty($dest_url)){
			
			OA_Dal_Delivery_query("INSERT INTO ".$table_prefix."dj_emailzone_settings (destination_url) VALUES('".$dest_url."')");
		}
	}else{
	
		if(!empty($dest_url)){	
			
			OA_Dal_Delivery_query("UPDATE ".$table_prefix."dj_emailzone_settings SET destination_url='".$dest_url."'") or die("update");
		}
	}
}



// Set the correct section of the settings pages and display the drop-down menu
$setPref = $oOptions->getSettingsPreferences($prefSection);
$title = $setPref[$prefSection]['name'];

// Display the settings page's header and sections
$oHeaderModel = new OA_Admin_UI_Model_PageHeaderModel($title);
phpAds_PageHeader('account-settings-index', $oHeaderModel);


// Prepare an array of HTML elements to display for the form, and
// output using the $oOption object
$dest = OA_Dal_Delivery_query("SELECT * FROM ".$table_prefix."dj_emailzone_settings")or die("query error");
$dest = OA_Dal_Delivery_fetchAssoc($dest);
//~ echo "<pre>";
//~ print_r($dest);
$destination_url = $dest['destination_url'] ? $dest['destination_url'] :'';
//~ echo $destination_url;
$aSettings = array (
    array (
       'text'  => $strEmailAddresses,
       'items' => array (
            array (
                'type'    => 'text',
                'name'    => 'destination_url',
                'text'    => "Set Global Destination url",
                'req'     => true,
                'size'    => 35,
                'check'   => 'url',
				'value'	  => $destination_url
            ),
            array (
                'type'    => 'break'
            )
           )
           )
           
);
$oOptions->show($aSettings, $aErrormessage);

// Display the page footer
phpAds_PageFooter();
